<?php
/* Lazy Slider for Joomla!
--------------------------------------------------------------
 Copyright (C) 2017 AddonDev. All rights reserved.
 Website: https://addondev.com
 GitHub: https://github.com/philip-sorokin
 Developer: Philip Sorokin
 Location: Russia, Moscow
 E-mail: philip.sorokin@gmail.com
 Created: October 2017
 License: GNU GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
--------------------------------------------------------------- */

defined('_JEXEC') or die;

JLoader::register('ModLazysliderHelper', __DIR__ . '/helper.php');

if (ModLazysliderHelper::$started)
{
	return;
}

ModLazysliderHelper::$started = true;
$directory = $params->get('directory');

if ($directory == -1)
{
	$directory = "/modules/mod_lazyslider/demo";
}
else
{
	$directory = "/images/$directory";
}

$code = substr(JFactory::getLanguage()->getTag(), 0, 2);
$images = [];

$setVersion = $params->get('set_version');

foreach(scandir(JPATH_SITE . $directory) as $name)
{
	$dotpos = mb_strrpos($name, '.');
	
	if ($dotpos !== false)
	{
		$flen = mb_strlen($name);
		$offset = $dotpos - $flen + 1;
		
		$fext = mb_strtolower(mb_substr($name, $offset));
		
		$extensions = ['html', 'htm', 'png', 'jpg', 'gif', 'bmp'];
		$extKey = array_search($fext, $extensions);
		
		if ($extKey !== false)
		{
			$lang = null;
			$path = mb_substr($name, 0, $dotpos);
			
			if ($extKey <= 1)
			{
				if (mb_strripos($path, ".$code"))
				{
					$lang = $code;
					$path = mb_substr($path, 0, -3);
				}
			}
			
			$index = md5($path);
			
			if (!isset($image[$index]))
			{
				$image[$index] = [];
			}
			
			if ($extKey <= 1)
			{
				$newIndex = 1;
				
				if (isset($images[$index][$newIndex]) && empty($lang))
				{
					continue;
				}
			}
			else
			{
				$newIndex = 0;
			}
			
			$version = '';
			
			if ($setVersion)
			{
				$version = "?v=" . md5(filemtime(JPATH_SITE . "$directory/$name"));
			}
			
			$images[$index][$newIndex] = JUri::root(true) . "$directory/$name" . $version; 
		}
	}
}

$images = array_values(array_filter($images, function($el) {
	return isset($el[0]);
}));

usort($images, function($a, $b) {
	return strnatcmp($a[0], $b[0]);
});

$doc = JFactory::getDocument();
$app = JFactory::getApplication();

JHtml::_('jquery.framework');
JHtml::_('bootstrap.framework');

$doc->addStyleSheet('media/jui/css/bootstrap.min.css');
$doc->addStyleSheet(($sheetName = 'modules/mod_lazyslider/assets/css/lazyslider.css'), ['version' => md5(filemtime(JPATH_SITE . "/$sheetName"))]);
$doc->addScript(($scriptName = 'modules/mod_lazyslider/assets/js/lazyslider.js'), ['version' => md5(filemtime(JPATH_SITE . "/$scriptName"))], ['defer' => 'defer']);

$options = [];

$settings = array_merge(['root' => JUri::root(true)], json_decode($params, true));

foreach ($settings as $key => $val)
{
	if ($key === 'directory')
	{
		break;
	}
	
	if (!is_numeric($val))
	{
		$val = "'$val'";
	}
	
	$options[] = "$key: $val";
}

$doc->addScriptDeclaration('window.lazySlider = {' . implode(', ', $options) . '};');
require JModuleHelper::getLayoutPath('mod_' . $module->name, $params->get('layout', 'default'));;
