<?php
/* Lazy Slider for Joomla!
--------------------------------------------------------------
 Copyright (C) 2017 AddonDev. All rights reserved.
 Website: https://addondev.com
 GitHub: https://github.com/philip-sorokin
 Developer: Philip Sorokin
 Location: Russia, Moscow
 E-mail: philip.sorokin@gmail.com
 Created: October 2017
 License: GNU GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
--------------------------------------------------------------- */

defined('_JEXEC') or die;

?>

<div id="lazySlider">
	<div class="carousel-inner">
		<?php foreach ($images as $key => $list) : ?>
			 <div class="item <?php if (!$key) echo 'active'; ?>" data-order="<?php echo $key; ?>">
				<img src="modules/mod_lazyslider/assets/img/blank.gif" data-lazyslider-src="<?php echo $list[0]; ?>" class="lazyslide" alt="" />
				<?php if (!empty($list[1])) : ?>
					<div class="lazySlider-caption" data-path="<?php echo $list[1]; ?>"></div>
				<?php endif; ?>
			</div>
		<?php endforeach; ?>
	</div>
	<a class="lazySlider-controls lazySlider-nav-arrows lazySlider-nav-arrow-left" href="#lazySlider" data-slide="prev">
		<span></span>
	</a>
	<a class="lazySlider-controls lazySlider-nav-arrows lazySlider-nav-arrow-right" href="#lazySlider" data-slide="next">
		<span></span>
	</a>
	<div class="lazySlider-controls lazySlider-nav-indicators">
		<ol class="carousel-indicators">
			<?php foreach ($images as $key => $list) : ?>
				<li data-goto="<?php echo $key; ?>" class="lazySlider-nav-indicator <?php if (!$key) echo 'active'; ?>"></li>
			<?php endforeach; ?>
		</ol>
	</div>
	<div class="lazySlider-controls lazySlider-play-buttons">
		<button type="button" class="btn btn-small btn-xs lazySlider-btn-pause"></button>
		<button type="button" class="btn btn-small btn-xs lazySlider-btn-play"></button>
	</div>
	<div class="lazySlider-loader">
		<div class="lazySlider-meter"></div>
	</div>
</div>
