<?php

defined('_JEXEC') or die('Restricted access');

/** Extended Login and Registration for Joomla!
---------------------------------------------------------------
 Copyright (C) 2017 Addon Dev. All rights reserved.
 Website: https://addondev.com
 GitHub: https://github.com/philip-sorokin
 Developer: Philip Sorokin
 Location: Russia, Moscow
 E-mail: philip.sorokin@gmail.com
 Created: November 2017
 License: GNU GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
---------------------------------------------------------------- */

class PlgSystemExtLoginRegistration extends JPlugin
{
	public function onAfterRoute()
	{
		$app = JFactory::getApplication();
		$input = $app->input;
		$method = $input->getMethod();
		$option = $app->input->get('option');
		$view = $app->input->get('view');
		$layout = $app->input->get('layout');
		$task = $app->input->get('task');
		
		$dispatcher = JEventDispatcher::getInstance();
		$options = ['com_users'];
		
		if ($this->params->get('com_login'))
		{
			$options[] = 'com_login';
		}
		
		if (in_array($option, $options))
		{
			if ($this->params->get('combined_registration') && in_array($view, ['login', 'registration']) && JComponentHelper::getParams('com_users')->get('allowUserRegistration'))
			{
				$input->set('view', 'combined');
				$app->getRouter()->setVar('view', 'combined');

				JLoader::register('UsersController', __DIR__ . '/includes/controller.php');
				JLoader::register('UsersViewCombined', __DIR__ . '/includes/views/combined/view.html.php');
			}
			
			if (in_array($task, ['login', 'user.login']) && $this->params->get("hide_username"))
			{
				$email = $app->input->$method->get('username', '', 'RAW');
				
				$dbo = JFactory::getDbo();
				
				$username = $dbo->setQuery($dbo->getQuery(true)
					->select($dbo->qn('username'))
					->from($dbo->qn('#__users'))
					->where($dbo->qn('email') . ' = ' . $dbo->q($email))
					->where($dbo->qn('username') . ' <> ' . $dbo->q($email))
				)->loadResult();
				
				if ($username)
				{
					$app->input->$method->set('username', $username);
				}
			}
			else if (in_array($task, ['registration.register', 'profile.save']))
			{
				$form = $app->input->$method->get('jform', [], 'array');
				
				$this->applyCallback(function($fieldName1, $fieldName2) use (&$form)
				{
					$form[$fieldName2] = $form[$fieldName1];
				});
				
				$app->input->post->set('jform', $form);
			}
		}
		
		if ($task !== 'registration.register')
		{
			$dispatcher->register('onContentPrepareForm', [$this, 'onUserPrepareForm']);
		}	
	}

	public function onUserPrepareForm($form, $data)
	{
		$app = JFactory::getApplication();
		
		if (in_array($form->getName(), ['com_users.registration', 'com_users.profile']) && $app->input->get('task') !== 'save')
		{
			$this->applyCallback(function($fieldName1, $fieldName2) use ($form)
			{
				$form->removeField($fieldName2);				
			});
			
			$fieldsetName = 'default';
			$fieldset = $form->getFieldset('default');
			
			if (empty($fieldset))
			{
				$fieldsetName = 'core';
				$fieldset = $form->getFieldset('core');
			}
			
			if (!$form->getField('password2'))
			{
				$password1 = $form->getField('password1');
				
				if ($password1)
				{
					$attributes = [
						'name' => 'password1',
						'type' => 'password',
						'label' => 'COM_USERS_PROFILE_PASSWORD1_LABEL',
						'description' => 'COM_USERS_DESIRED_PASSWORD',
						'autocomplete' => 'off',
						'class' => 'validate-password',
						'field' => 'password1',
						'filter' => 'raw',
						'size' => '30',
						'validate' => 'password',
						'required' => 'true'
					];
					
					$newField = new SimpleXMLElement("<field></field>");
					
					foreach ($attributes as $name => $value)
					{
						$newField->addAttribute($name, $value);
					}
					
					$form->removeField('password1');
					$form->setField($newField, null, null, $fieldsetName);
				}
			}
		}
		
		if ($form->getName() === 'com_users.login' && $this->params->get("hide_username"))
		{
			$form->setFieldAttribute('username', 'label', JText::_('COM_USERS_REGISTER_EMAIL1_LABEL') . ' / ' . JText::_('COM_USERS_LOGIN_USERNAME_LABEL'));
		}
	}
	
	protected function applyCallback(callable $callback)
	{
		$hidden = ['password', 'email', 'username', 'name'];
		
		foreach($hidden as $fieldName)
		{
			if ($fieldName === 'name')
			{
				$fieldName1 = 'username';
				$fieldName2 = 'name';
			}
			else if ($fieldName === 'username')
			{
				$fieldName1 = 'email1';
				$fieldName2 = 'username';
			}
			else
			{
				$fieldName1 = $fieldName . '1';
				$fieldName2 = $fieldName . '2';
			}
			
			if ($this->params->get("hide_$fieldName"))
			{
				call_user_func_array($callback, [$fieldName1, $fieldName2]);
			}
		}
	}
}
